package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{ProjectRef, ExperimentName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetExperimentRequest(
    experiment: ExperimentName,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetExperimentRequest = {
    import GetExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetExperimentRequest
      .builder()
      .experiment(ExperimentName.unwrap(experiment): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetExperimentRequest.ReadOnly =
    zio.aws.evidently.model.GetExperimentRequest.wrap(buildAwsValue())
}
object GetExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetExperimentRequest =
      zio.aws.evidently.model.GetExperimentRequest(experiment, project)
    def experiment: ExperimentName
    def project: ProjectRef
    def getExperiment: ZIO[Any, Nothing, ExperimentName] =
      ZIO.succeed(experiment)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentRequest
  ) extends zio.aws.evidently.model.GetExperimentRequest.ReadOnly {
    override val experiment: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.experiment())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentRequest
  ): zio.aws.evidently.model.GetExperimentRequest.ReadOnly = new Wrapper(impl)
}
