package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait ExperimentStatus {
  def unwrap: software.amazon.awssdk.services.evidently.model.ExperimentStatus
}
object ExperimentStatus {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentStatus
  ): zio.aws.evidently.model.ExperimentStatus = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStatus =
      software.amazon.awssdk.services.evidently.model.ExperimentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.evidently.model.ExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStatus =
      software.amazon.awssdk.services.evidently.model.ExperimentStatus.CREATED
  }
  case object UPDATING extends zio.aws.evidently.model.ExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStatus =
      software.amazon.awssdk.services.evidently.model.ExperimentStatus.UPDATING
  }
  case object RUNNING extends zio.aws.evidently.model.ExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStatus =
      software.amazon.awssdk.services.evidently.model.ExperimentStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.evidently.model.ExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStatus =
      software.amazon.awssdk.services.evidently.model.ExperimentStatus.COMPLETED
  }
  case object CANCELLED extends zio.aws.evidently.model.ExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStatus =
      software.amazon.awssdk.services.evidently.model.ExperimentStatus.CANCELLED
  }
}
