package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.evidently.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.EventType
  ): zio.aws.evidently.model.EventType = value match {
    case software.amazon.awssdk.services.evidently.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.EventType.AWS_EVIDENTLY_EVALUATION =>
      val r = `aws.evidently.evaluation`
      r
    case software.amazon.awssdk.services.evidently.model.EventType.AWS_EVIDENTLY_CUSTOM =>
      val r = `aws.evidently.custom`
      r
  }
  case object unknownToSdkVersion extends zio.aws.evidently.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.EventType =
      software.amazon.awssdk.services.evidently.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object `aws.evidently.evaluation`
      extends zio.aws.evidently.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.EventType =
      software.amazon.awssdk.services.evidently.model.EventType.AWS_EVIDENTLY_EVALUATION
  }
  case object `aws.evidently.custom` extends zio.aws.evidently.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.EventType =
      software.amazon.awssdk.services.evidently.model.EventType.AWS_EVIDENTLY_CUSTOM
  }
}
