package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{ProjectRef, ExperimentName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteExperimentRequest(
    experiment: ExperimentName,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest = {
    import DeleteExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest
      .builder()
      .experiment(ExperimentName.unwrap(experiment): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.DeleteExperimentRequest.ReadOnly =
    zio.aws.evidently.model.DeleteExperimentRequest.wrap(buildAwsValue())
}
object DeleteExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.DeleteExperimentRequest =
      zio.aws.evidently.model.DeleteExperimentRequest(experiment, project)
    def experiment: ExperimentName
    def project: ProjectRef
    def getExperiment: ZIO[Any, Nothing, ExperimentName] =
      ZIO.succeed(experiment)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest
  ) extends zio.aws.evidently.model.DeleteExperimentRequest.ReadOnly {
    override val experiment: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.experiment())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest
  ): zio.aws.evidently.model.DeleteExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
