package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  SegmentName,
  TagValue,
  SegmentPattern,
  Description,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSegmentRequest(
    description: Optional[Description] = Optional.Absent,
    name: SegmentName,
    pattern: SegmentPattern,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateSegmentRequest = {
    import CreateSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateSegmentRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(SegmentName.unwrap(name): java.lang.String)
      .pattern(SegmentPattern.unwrap(pattern): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateSegmentRequest.ReadOnly =
    zio.aws.evidently.model.CreateSegmentRequest.wrap(buildAwsValue())
}
object CreateSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateSegmentRequest =
      zio.aws.evidently.model.CreateSegmentRequest(
        description.map(value => value),
        name,
        pattern,
        tags.map(value => value)
      )
    def description: Optional[Description]
    def name: SegmentName
    def pattern: SegmentPattern
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, SegmentName] = ZIO.succeed(name)
    def getPattern: ZIO[Any, Nothing, SegmentPattern] = ZIO.succeed(pattern)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateSegmentRequest
  ) extends zio.aws.evidently.model.CreateSegmentRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val name: SegmentName =
      zio.aws.evidently.model.primitives.SegmentName(impl.name())
    override val pattern: SegmentPattern =
      zio.aws.evidently.model.primitives.SegmentPattern(impl.pattern())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateSegmentRequest
  ): zio.aws.evidently.model.CreateSegmentRequest.ReadOnly = new Wrapper(impl)
}
