package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateProjectResponse(
    project: zio.aws.evidently.model.Project
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateProjectResponse = {
    import UpdateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateProjectResponse
      .builder()
      .project(project.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateProjectResponse.ReadOnly =
    zio.aws.evidently.model.UpdateProjectResponse.wrap(buildAwsValue())
}
object UpdateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateProjectResponse =
      zio.aws.evidently.model.UpdateProjectResponse(project.asEditable)
    def project: zio.aws.evidently.model.Project.ReadOnly
    def getProject
        : ZIO[Any, Nothing, zio.aws.evidently.model.Project.ReadOnly] =
      ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectResponse
  ) extends zio.aws.evidently.model.UpdateProjectResponse.ReadOnly {
    override val project: zio.aws.evidently.model.Project.ReadOnly =
      zio.aws.evidently.model.Project.wrap(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectResponse
  ): zio.aws.evidently.model.UpdateProjectResponse.ReadOnly = new Wrapper(impl)
}
