package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{ProjectRef, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProjectRequest(
    appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResourceConfig
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateProjectRequest
      .builder()
      .optionallyWith(appConfigResource.map(value => value.buildAwsValue()))(
        _.appConfigResource
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateProjectRequest.ReadOnly =
    zio.aws.evidently.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateProjectRequest =
      zio.aws.evidently.model.UpdateProjectRequest(
        appConfigResource.map(value => value.asEditable),
        description.map(value => value),
        project
      )
    def appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly
    ]
    def description: Optional[Description]
    def project: ProjectRef
    def getAppConfigResource: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("appConfigResource", appConfigResource)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectRequest
  ) extends zio.aws.evidently.model.UpdateProjectRequest.ReadOnly {
    override val appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appConfigResource())
      .map(value =>
        zio.aws.evidently.model.ProjectAppConfigResourceConfig.wrap(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectRequest
  ): zio.aws.evidently.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
