package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.{Timestamp, SplitWeight, GroupName}
import scala.jdk.CollectionConverters._
final case class ScheduledSplit(
    groupWeights: Optional[Map[GroupName, SplitWeight]] = Optional.Absent,
    segmentOverrides: Optional[
      Iterable[zio.aws.evidently.model.SegmentOverride]
    ] = Optional.Absent,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ScheduledSplit = {
    import ScheduledSplit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ScheduledSplit
      .builder()
      .optionallyWith(
        groupWeights.map(value =>
          value
            .map({ case (key, value) =>
              (GroupName.unwrap(key): java.lang.String) -> (SplitWeight.unwrap(
                value
              ): java.lang.Long)
            })
            .asJava
        )
      )(_.groupWeights)
      .optionallyWith(
        segmentOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentOverrides)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ScheduledSplit.ReadOnly =
    zio.aws.evidently.model.ScheduledSplit.wrap(buildAwsValue())
}
object ScheduledSplit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ScheduledSplit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ScheduledSplit =
      zio.aws.evidently.model.ScheduledSplit(
        groupWeights.map(value => value),
        segmentOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime
      )
    def groupWeights: Optional[Map[GroupName, SplitWeight]]
    def segmentOverrides
        : Optional[List[zio.aws.evidently.model.SegmentOverride.ReadOnly]]
    def startTime: Timestamp
    def getGroupWeights: ZIO[Any, AwsError, Map[GroupName, SplitWeight]] =
      AwsError.unwrapOptionField("groupWeights", groupWeights)
    def getSegmentOverrides: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.SegmentOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("segmentOverrides", segmentOverrides)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplit
  ) extends zio.aws.evidently.model.ScheduledSplit.ReadOnly {
    override val groupWeights: Optional[Map[GroupName, SplitWeight]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupWeights())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.evidently.model.primitives.GroupName(
                key
              ) -> zio.aws.evidently.model.primitives.SplitWeight(value)
            })
            .toMap
        )
    override val segmentOverrides
        : Optional[List[zio.aws.evidently.model.SegmentOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.SegmentOverride.wrap(item)
          }.toList
        )
    override val startTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplit
  ): zio.aws.evidently.model.ScheduledSplit.ReadOnly = new Wrapper(impl)
}
