package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSegmentsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    segments: Optional[Iterable[zio.aws.evidently.model.Segment]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListSegmentsResponse = {
    import ListSegmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListSegmentsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        segments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segments)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListSegmentsResponse.ReadOnly =
    zio.aws.evidently.model.ListSegmentsResponse.wrap(buildAwsValue())
}
object ListSegmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListSegmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListSegmentsResponse =
      zio.aws.evidently.model.ListSegmentsResponse(
        nextToken.map(value => value),
        segments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def segments: Optional[List[zio.aws.evidently.model.Segment.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSegments
        : ZIO[Any, AwsError, List[zio.aws.evidently.model.Segment.ReadOnly]] =
      AwsError.unwrapOptionField("segments", segments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentsResponse
  ) extends zio.aws.evidently.model.ListSegmentsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val segments
        : Optional[List[zio.aws.evidently.model.Segment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.Segment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentsResponse
  ): zio.aws.evidently.model.ListSegmentsResponse.ReadOnly = new Wrapper(impl)
}
