package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSegmentReferencesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    referencedBy: Optional[Iterable[zio.aws.evidently.model.RefResource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse = {
    import ListSegmentReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        referencedBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referencedBy)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.ListSegmentReferencesResponse.ReadOnly =
    zio.aws.evidently.model.ListSegmentReferencesResponse.wrap(buildAwsValue())
}
object ListSegmentReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListSegmentReferencesResponse =
      zio.aws.evidently.model.ListSegmentReferencesResponse(
        nextToken.map(value => value),
        referencedBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def referencedBy
        : Optional[List[zio.aws.evidently.model.RefResource.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReferencedBy: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.RefResource.ReadOnly
    ]] = AwsError.unwrapOptionField("referencedBy", referencedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse
  ) extends zio.aws.evidently.model.ListSegmentReferencesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val referencedBy
        : Optional[List[zio.aws.evidently.model.RefResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referencedBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.RefResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse
  ): zio.aws.evidently.model.ListSegmentReferencesResponse.ReadOnly =
    new Wrapper(impl)
}
