package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.SegmentRef
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSegmentRequest(segment: SegmentRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetSegmentRequest = {
    import GetSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetSegmentRequest
      .builder()
      .segment(SegmentRef.unwrap(segment): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetSegmentRequest.ReadOnly =
    zio.aws.evidently.model.GetSegmentRequest.wrap(buildAwsValue())
}
object GetSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetSegmentRequest =
      zio.aws.evidently.model.GetSegmentRequest(segment)
    def segment: SegmentRef
    def getSegment: ZIO[Any, Nothing, SegmentRef] = ZIO.succeed(segment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetSegmentRequest
  ) extends zio.aws.evidently.model.GetSegmentRequest.ReadOnly {
    override val segment: SegmentRef =
      zio.aws.evidently.model.primitives.SegmentRef(impl.segment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetSegmentRequest
  ): zio.aws.evidently.model.GetSegmentRequest.ReadOnly = new Wrapper(impl)
}
