package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class StopLaunchResponse(
    endedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StopLaunchResponse = {
    import StopLaunchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StopLaunchResponse
      .builder()
      .optionallyWith(endedTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endedTime
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StopLaunchResponse.ReadOnly =
    zio.aws.evidently.model.StopLaunchResponse.wrap(buildAwsValue())
}
object StopLaunchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StopLaunchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StopLaunchResponse =
      zio.aws.evidently.model.StopLaunchResponse(endedTime.map(value => value))
    def endedTime: Optional[Timestamp]
    def getEndedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endedTime", endedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StopLaunchResponse
  ) extends zio.aws.evidently.model.StopLaunchResponse.ReadOnly {
    override val endedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endedTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StopLaunchResponse
  ): zio.aws.evidently.model.StopLaunchResponse.ReadOnly = new Wrapper(impl)
}
