package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{ProjectRef, LaunchName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartLaunchRequest(launch: LaunchName, project: ProjectRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StartLaunchRequest = {
    import StartLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StartLaunchRequest
      .builder()
      .launch(LaunchName.unwrap(launch): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StartLaunchRequest.ReadOnly =
    zio.aws.evidently.model.StartLaunchRequest.wrap(buildAwsValue())
}
object StartLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StartLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StartLaunchRequest =
      zio.aws.evidently.model.StartLaunchRequest(launch, project)
    def launch: LaunchName
    def project: ProjectRef
    def getLaunch: ZIO[Any, Nothing, LaunchName] = ZIO.succeed(launch)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StartLaunchRequest
  ) extends zio.aws.evidently.model.StartLaunchRequest.ReadOnly {
    override val launch: LaunchName =
      zio.aws.evidently.model.primitives.LaunchName(impl.launch())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StartLaunchRequest
  ): zio.aws.evidently.model.StartLaunchRequest.ReadOnly = new Wrapper(impl)
}
