package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{SplitWeight, GroupName, SegmentRef}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SegmentOverride(
    evaluationOrder: Long,
    segment: SegmentRef,
    weights: Map[GroupName, SplitWeight]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.SegmentOverride = {
    import SegmentOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.SegmentOverride
      .builder()
      .evaluationOrder(evaluationOrder: java.lang.Long)
      .segment(SegmentRef.unwrap(segment): java.lang.String)
      .weights(
        weights
          .map({ case (key, value) =>
            (GroupName.unwrap(key): java.lang.String) -> (SplitWeight
              .unwrap(value): java.lang.Long)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.SegmentOverride.ReadOnly =
    zio.aws.evidently.model.SegmentOverride.wrap(buildAwsValue())
}
object SegmentOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.SegmentOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.SegmentOverride =
      zio.aws.evidently.model.SegmentOverride(evaluationOrder, segment, weights)
    def evaluationOrder: Long
    def segment: SegmentRef
    def weights: Map[GroupName, SplitWeight]
    def getEvaluationOrder: ZIO[Any, Nothing, Long] =
      ZIO.succeed(evaluationOrder)
    def getSegment: ZIO[Any, Nothing, SegmentRef] = ZIO.succeed(segment)
    def getWeights: ZIO[Any, Nothing, Map[GroupName, SplitWeight]] =
      ZIO.succeed(weights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.SegmentOverride
  ) extends zio.aws.evidently.model.SegmentOverride.ReadOnly {
    override val evaluationOrder: Long = impl.evaluationOrder(): Long
    override val segment: SegmentRef =
      zio.aws.evidently.model.primitives.SegmentRef(impl.segment())
    override val weights: Map[GroupName, SplitWeight] = impl
      .weights()
      .asScala
      .map({ case (key, value) =>
        zio.aws.evidently.model.primitives.GroupName(
          key
        ) -> zio.aws.evidently.model.primitives.SplitWeight(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.SegmentOverride
  ): zio.aws.evidently.model.SegmentOverride.ReadOnly = new Wrapper(impl)
}
