package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait ExperimentType {
  def unwrap: software.amazon.awssdk.services.evidently.model.ExperimentType
}
object ExperimentType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentType
  ): zio.aws.evidently.model.ExperimentType = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentType.AWS_EVIDENTLY_ONLINEAB =>
      val r = `aws.evidently.onlineab`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentType =
      software.amazon.awssdk.services.evidently.model.ExperimentType.UNKNOWN_TO_SDK_VERSION
  }
  case object `aws.evidently.onlineab`
      extends zio.aws.evidently.model.ExperimentType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentType =
      software.amazon.awssdk.services.evidently.model.ExperimentType.AWS_EVIDENTLY_ONLINEAB
  }
}
