package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.SegmentRef
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSegmentRequest(segment: SegmentRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.DeleteSegmentRequest = {
    import DeleteSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.DeleteSegmentRequest
      .builder()
      .segment(SegmentRef.unwrap(segment): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.DeleteSegmentRequest.ReadOnly =
    zio.aws.evidently.model.DeleteSegmentRequest.wrap(buildAwsValue())
}
object DeleteSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.DeleteSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.DeleteSegmentRequest =
      zio.aws.evidently.model.DeleteSegmentRequest(segment)
    def segment: SegmentRef
    def getSegment: ZIO[Any, Nothing, SegmentRef] = ZIO.succeed(segment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.DeleteSegmentRequest
  ) extends zio.aws.evidently.model.DeleteSegmentRequest.ReadOnly {
    override val segment: SegmentRef =
      zio.aws.evidently.model.primitives.SegmentRef(impl.segment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.DeleteSegmentRequest
  ): zio.aws.evidently.model.DeleteSegmentRequest.ReadOnly = new Wrapper(impl)
}
