package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  TagValue,
  TagKey,
  ProjectName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResourceConfig
    ] = Optional.Absent,
    dataDelivery: Optional[zio.aws.evidently.model.ProjectDataDeliveryConfig] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    name: ProjectName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateProjectRequest
      .builder()
      .optionallyWith(appConfigResource.map(value => value.buildAwsValue()))(
        _.appConfigResource
      )
      .optionallyWith(dataDelivery.map(value => value.buildAwsValue()))(
        _.dataDelivery
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateProjectRequest.ReadOnly =
    zio.aws.evidently.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateProjectRequest =
      zio.aws.evidently.model.CreateProjectRequest(
        appConfigResource.map(value => value.asEditable),
        dataDelivery.map(value => value.asEditable),
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly
    ]
    def dataDelivery
        : Optional[zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly]
    def description: Optional[Description]
    def name: ProjectName
    def tags: Optional[Map[TagKey, TagValue]]
    def getAppConfigResource: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("appConfigResource", appConfigResource)
    def getDataDelivery: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataDelivery", dataDelivery)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateProjectRequest
  ) extends zio.aws.evidently.model.CreateProjectRequest.ReadOnly {
    override val appConfigResource: Optional[
      zio.aws.evidently.model.ProjectAppConfigResourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appConfigResource())
      .map(value =>
        zio.aws.evidently.model.ProjectAppConfigResourceConfig.wrap(value)
      )
    override val dataDelivery
        : Optional[zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDelivery())
        .map(value =>
          zio.aws.evidently.model.ProjectDataDeliveryConfig.wrap(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val name: ProjectName =
      zio.aws.evidently.model.primitives.ProjectName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateProjectRequest
  ): zio.aws.evidently.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
