package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  MetricUnitLabel,
  CwDimensionSafeName,
  JsonValue,
  JsonPath
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricDefinition(
    entityIdKey: Optional[JsonPath] = Optional.Absent,
    eventPattern: Optional[JsonValue] = Optional.Absent,
    name: Optional[CwDimensionSafeName] = Optional.Absent,
    unitLabel: Optional[MetricUnitLabel] = Optional.Absent,
    valueKey: Optional[JsonPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricDefinition = {
    import MetricDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricDefinition
      .builder()
      .optionallyWith(
        entityIdKey.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.entityIdKey)
      .optionallyWith(
        eventPattern.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(
        name.map(value => CwDimensionSafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        unitLabel.map(value => MetricUnitLabel.unwrap(value): java.lang.String)
      )(_.unitLabel)
      .optionallyWith(
        valueKey.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.valueKey)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricDefinition.ReadOnly =
    zio.aws.evidently.model.MetricDefinition.wrap(buildAwsValue())
}
object MetricDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricDefinition =
      zio.aws.evidently.model.MetricDefinition(
        entityIdKey.map(value => value),
        eventPattern.map(value => value),
        name.map(value => value),
        unitLabel.map(value => value),
        valueKey.map(value => value)
      )
    def entityIdKey: Optional[JsonPath]
    def eventPattern: Optional[JsonValue]
    def name: Optional[CwDimensionSafeName]
    def unitLabel: Optional[MetricUnitLabel]
    def valueKey: Optional[JsonPath]
    def getEntityIdKey: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("entityIdKey", entityIdKey)
    def getEventPattern: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getName: ZIO[Any, AwsError, CwDimensionSafeName] =
      AwsError.unwrapOptionField("name", name)
    def getUnitLabel: ZIO[Any, AwsError, MetricUnitLabel] =
      AwsError.unwrapOptionField("unitLabel", unitLabel)
    def getValueKey: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("valueKey", valueKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinition
  ) extends zio.aws.evidently.model.MetricDefinition.ReadOnly {
    override val entityIdKey: Optional[JsonPath] = zio.aws.core.internal
      .optionalFromNullable(impl.entityIdKey())
      .map(value => zio.aws.evidently.model.primitives.JsonPath(value))
    override val eventPattern: Optional[JsonValue] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val name: Optional[CwDimensionSafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.evidently.model.primitives.CwDimensionSafeName(value)
      )
    override val unitLabel: Optional[MetricUnitLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.unitLabel())
      .map(value => zio.aws.evidently.model.primitives.MetricUnitLabel(value))
    override val valueKey: Optional[JsonPath] = zio.aws.core.internal
      .optionalFromNullable(impl.valueKey())
      .map(value => zio.aws.evidently.model.primitives.JsonPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinition
  ): zio.aws.evidently.model.MetricDefinition.ReadOnly = new Wrapper(impl)
}
