package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  GroupName,
  VariationName,
  FeatureName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchGroup(
    description: Optional[Description] = Optional.Absent,
    featureVariations: Map[FeatureName, VariationName],
    name: GroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.LaunchGroup = {
    import LaunchGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.LaunchGroup
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .featureVariations(
        featureVariations
          .map({ case (key, value) =>
            (FeatureName.unwrap(key): java.lang.String) -> (VariationName
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .name(GroupName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.LaunchGroup.ReadOnly =
    zio.aws.evidently.model.LaunchGroup.wrap(buildAwsValue())
}
object LaunchGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.LaunchGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.LaunchGroup =
      zio.aws.evidently.model
        .LaunchGroup(description.map(value => value), featureVariations, name)
    def description: Optional[Description]
    def featureVariations: Map[FeatureName, VariationName]
    def name: GroupName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFeatureVariations
        : ZIO[Any, Nothing, Map[FeatureName, VariationName]] =
      ZIO.succeed(featureVariations)
    def getName: ZIO[Any, Nothing, GroupName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.LaunchGroup
  ) extends zio.aws.evidently.model.LaunchGroup.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val featureVariations: Map[FeatureName, VariationName] = impl
      .featureVariations()
      .asScala
      .map({ case (key, value) =>
        zio.aws.evidently.model.primitives.FeatureName(
          key
        ) -> zio.aws.evidently.model.primitives.VariationName(value)
      })
      .toMap
    override val name: GroupName =
      zio.aws.evidently.model.primitives.GroupName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.LaunchGroup
  ): zio.aws.evidently.model.LaunchGroup.ReadOnly = new Wrapper(impl)
}
