package zio.aws.evidently.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.evidently.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class GetExperimentResultsResponse(
    details: Optional[String] = Optional.Absent,
    reports: Optional[Iterable[zio.aws.evidently.model.ExperimentReport]] =
      Optional.Absent,
    resultsData: Optional[
      Iterable[zio.aws.evidently.model.ExperimentResultsData]
    ] = Optional.Absent,
    timestamps: Optional[Iterable[Timestamp]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse = {
    import GetExperimentResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
      .builder()
      .optionallyWith(details.map(value => value: java.lang.String))(_.details)
      .optionallyWith(
        reports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reports)
      .optionallyWith(
        resultsData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultsData)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly =
    zio.aws.evidently.model.GetExperimentResultsResponse.wrap(buildAwsValue())
}
object GetExperimentResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetExperimentResultsResponse =
      zio.aws.evidently.model.GetExperimentResultsResponse(
        details.map(value => value),
        reports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultsData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timestamps.map(value => value)
      )
    def details: Optional[String]
    def reports
        : Optional[List[zio.aws.evidently.model.ExperimentReport.ReadOnly]]
    def resultsData
        : Optional[List[zio.aws.evidently.model.ExperimentResultsData.ReadOnly]]
    def timestamps: Optional[List[Timestamp]]
    def getDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("details", details)
    def getReports: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ExperimentReport.ReadOnly
    ]] = AwsError.unwrapOptionField("reports", reports)
    def getResultsData: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ExperimentResultsData.ReadOnly
    ]] = AwsError.unwrapOptionField("resultsData", resultsData)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
  ) extends zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly {
    override val details: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => value: String)
    override val reports
        : Optional[List[zio.aws.evidently.model.ExperimentReport.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.ExperimentReport.wrap(item)
          }.toList
        )
    override val resultsData: Optional[
      List[zio.aws.evidently.model.ExperimentResultsData.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resultsData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.ExperimentResultsData.wrap(item)
        }.toList
      )
    override val timestamps: Optional[List[Timestamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.primitives.Timestamp(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
  ): zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly =
    new Wrapper(impl)
}
