package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  Arn,
  FeatureName,
  EntityId,
  JsonValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationResult(
    details: Optional[JsonValue] = Optional.Absent,
    entityId: EntityId,
    feature: FeatureName,
    project: Optional[Arn] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    value: Optional[zio.aws.evidently.model.VariableValue] = Optional.Absent,
    variation: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.EvaluationResult
      .builder()
      .optionallyWith(
        details.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.details)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .optionallyWith(
        project.map(value => Arn.unwrap(value): java.lang.String)
      )(_.project)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(variation.map(value => value: java.lang.String))(
        _.variation
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.EvaluationResult.ReadOnly =
    zio.aws.evidently.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.EvaluationResult =
      zio.aws.evidently.model.EvaluationResult(
        details.map(value => value),
        entityId,
        feature,
        project.map(value => value),
        reason.map(value => value),
        value.map(value => value.asEditable),
        variation.map(value => value)
      )
    def details: Optional[JsonValue]
    def entityId: EntityId
    def feature: FeatureName
    def project: Optional[Arn]
    def reason: Optional[String]
    def value: Optional[zio.aws.evidently.model.VariableValue.ReadOnly]
    def variation: Optional[String]
    def getDetails: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("details", details)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getProject: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("project", project)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getValue
        : ZIO[Any, AwsError, zio.aws.evidently.model.VariableValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getVariation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("variation", variation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.EvaluationResult
  ) extends zio.aws.evidently.model.EvaluationResult.ReadOnly {
    override val details: Optional[JsonValue] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val entityId: EntityId =
      zio.aws.evidently.model.primitives.EntityId(impl.entityId())
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val project: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.project())
      .map(value => zio.aws.evidently.model.primitives.Arn(value))
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val value
        : Optional[zio.aws.evidently.model.VariableValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.evidently.model.VariableValue.wrap(value))
    override val variation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.variation())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.EvaluationResult
  ): zio.aws.evidently.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
