package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.ProjectRef
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(project: ProjectRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.DeleteProjectRequest
      .builder()
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.DeleteProjectRequest.ReadOnly =
    zio.aws.evidently.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.DeleteProjectRequest =
      zio.aws.evidently.model.DeleteProjectRequest(project)
    def project: ProjectRef
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.DeleteProjectRequest
  ) extends zio.aws.evidently.model.DeleteProjectRequest.ReadOnly {
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.DeleteProjectRequest
  ): zio.aws.evidently.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
