package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateExperimentResponse(
    experiment: zio.aws.evidently.model.Experiment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse = {
    import UpdateExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse
      .builder()
      .experiment(experiment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly =
    zio.aws.evidently.model.UpdateExperimentResponse.wrap(buildAwsValue())
}
object UpdateExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateExperimentResponse =
      zio.aws.evidently.model.UpdateExperimentResponse(experiment.asEditable)
    def experiment: zio.aws.evidently.model.Experiment.ReadOnly
    def getExperiment
        : ZIO[Any, Nothing, zio.aws.evidently.model.Experiment.ReadOnly] =
      ZIO.succeed(experiment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse
  ) extends zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly {
    override val experiment: zio.aws.evidently.model.Experiment.ReadOnly =
      zio.aws.evidently.model.Experiment.wrap(impl.experiment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse
  ): zio.aws.evidently.model.UpdateExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
