package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  ProjectRef,
  ExperimentName,
  Timestamp
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StartExperimentRequest(
    analysisCompleteTime: Timestamp,
    experiment: ExperimentName,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StartExperimentRequest = {
    import StartExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StartExperimentRequest
      .builder()
      .analysisCompleteTime(Timestamp.unwrap(analysisCompleteTime): Instant)
      .experiment(ExperimentName.unwrap(experiment): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StartExperimentRequest.ReadOnly =
    zio.aws.evidently.model.StartExperimentRequest.wrap(buildAwsValue())
}
object StartExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StartExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StartExperimentRequest =
      zio.aws.evidently.model
        .StartExperimentRequest(analysisCompleteTime, experiment, project)
    def analysisCompleteTime: Timestamp
    def experiment: ExperimentName
    def project: ProjectRef
    def getAnalysisCompleteTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(analysisCompleteTime)
    def getExperiment: ZIO[Any, Nothing, ExperimentName] =
      ZIO.succeed(experiment)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StartExperimentRequest
  ) extends zio.aws.evidently.model.StartExperimentRequest.ReadOnly {
    override val analysisCompleteTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.analysisCompleteTime())
    override val experiment: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.experiment())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StartExperimentRequest
  ): zio.aws.evidently.model.StartExperimentRequest.ReadOnly = new Wrapper(impl)
}
