package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ScheduledSplitsLaunchConfig(
    steps: Iterable[zio.aws.evidently.model.ScheduledSplitConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchConfig = {
    import ScheduledSplitsLaunchConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchConfig
      .builder()
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly =
    zio.aws.evidently.model.ScheduledSplitsLaunchConfig.wrap(buildAwsValue())
}
object ScheduledSplitsLaunchConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ScheduledSplitsLaunchConfig =
      zio.aws.evidently.model.ScheduledSplitsLaunchConfig(steps.map { item =>
        item.asEditable
      })
    def steps: List[zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly]
    def getSteps: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly
    ]] = ZIO.succeed(steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchConfig
  ) extends zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly {
    override val steps
        : List[zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.evidently.model.ScheduledSplitConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchConfig
  ): zio.aws.evidently.model.ScheduledSplitsLaunchConfig.ReadOnly = new Wrapper(
    impl
  )
}
