package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{Timestamp, SplitWeight, GroupName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScheduledSplitConfig(
    groupWeights: Map[GroupName, SplitWeight],
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig = {
    import ScheduledSplitConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
      .builder()
      .groupWeights(
        groupWeights
          .map({ case (key, value) =>
            (GroupName.unwrap(key): java.lang.String) -> (SplitWeight
              .unwrap(value): java.lang.Long)
          })
          .asJava
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly =
    zio.aws.evidently.model.ScheduledSplitConfig.wrap(buildAwsValue())
}
object ScheduledSplitConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ScheduledSplitConfig =
      zio.aws.evidently.model.ScheduledSplitConfig(groupWeights, startTime)
    def groupWeights: Map[GroupName, SplitWeight]
    def startTime: Timestamp
    def getGroupWeights: ZIO[Any, Nothing, Map[GroupName, SplitWeight]] =
      ZIO.succeed(groupWeights)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
  ) extends zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly {
    override val groupWeights: Map[GroupName, SplitWeight] = impl
      .groupWeights()
      .asScala
      .map({ case (key, value) =>
        zio.aws.evidently.model.primitives.GroupName(
          key
        ) -> zio.aws.evidently.model.primitives.SplitWeight(value)
      })
      .toMap
    override val startTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplitConfig
  ): zio.aws.evidently.model.ScheduledSplitConfig.ReadOnly = new Wrapper(impl)
}
