package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{Timestamp, JsonValue}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Event(
    data: JsonValue,
    timestamp: Timestamp,
    `type`: zio.aws.evidently.model.EventType
) {
  def buildAwsValue(): software.amazon.awssdk.services.evidently.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Event
      .builder()
      .data(JsonValue.unwrap(data): java.lang.String)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Event.ReadOnly =
    zio.aws.evidently.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.evidently.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Event =
      zio.aws.evidently.model.Event(data, timestamp, `type`)
    def data: JsonValue
    def timestamp: Timestamp
    def `type`: zio.aws.evidently.model.EventType
    def getData: ZIO[Any, Nothing, JsonValue] = ZIO.succeed(data)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getType: ZIO[Any, Nothing, zio.aws.evidently.model.EventType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Event
  ) extends zio.aws.evidently.model.Event.ReadOnly {
    override val data: JsonValue =
      zio.aws.evidently.model.primitives.JsonValue(impl.data())
    override val timestamp: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.timestamp())
    override val `type`: zio.aws.evidently.model.EventType =
      zio.aws.evidently.model.EventType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Event
  ): zio.aws.evidently.model.Event.ReadOnly = new Wrapper(impl)
}
