package zio.aws.evidently
import zio.aws.evidently.model.primitives.{
  SplitWeight,
  VariationName,
  Timestamp,
  TagValue,
  TreatmentName,
  GroupName,
  EntityId,
  FeatureName,
  CwDimensionSafeName,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.evidently.model.primitives.ErrorCodeEnum.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.evidently.model.primitives.Arn.Type
    object CwDimensionSafeName extends Subtype[String]
    type CwDimensionSafeName =
      zio.aws.evidently.model.primitives.CwDimensionSafeName.Type
    object CwLogGroupSafeName extends Subtype[String]
    type CwLogGroupSafeName =
      zio.aws.evidently.model.primitives.CwLogGroupSafeName.Type
    object Description extends Subtype[String]
    type Description = zio.aws.evidently.model.primitives.Description.Type
    object EntityId extends Subtype[String]
    type EntityId = zio.aws.evidently.model.primitives.EntityId.Type
    object ErrorCodeEnum extends Subtype[String]
    type ErrorCodeEnum = zio.aws.evidently.model.primitives.ErrorCodeEnum.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.evidently.model.primitives.ErrorMessage.Type
    object ExperimentArn extends Subtype[String]
    type ExperimentArn = zio.aws.evidently.model.primitives.ExperimentArn.Type
    object ExperimentName extends Subtype[String]
    type ExperimentName = zio.aws.evidently.model.primitives.ExperimentName.Type
    object FeatureArn extends Subtype[String]
    type FeatureArn = zio.aws.evidently.model.primitives.FeatureArn.Type
    object FeatureName extends Subtype[String]
    type FeatureName = zio.aws.evidently.model.primitives.FeatureName.Type
    object GroupName extends Subtype[String]
    type GroupName = zio.aws.evidently.model.primitives.GroupName.Type
    type Integer = Int
    object JsonPath extends Subtype[String]
    type JsonPath = zio.aws.evidently.model.primitives.JsonPath.Type
    object JsonValue extends Subtype[String]
    type JsonValue = zio.aws.evidently.model.primitives.JsonValue.Type
    object LaunchArn extends Subtype[String]
    type LaunchArn = zio.aws.evidently.model.primitives.LaunchArn.Type
    object LaunchName extends Subtype[String]
    type LaunchName = zio.aws.evidently.model.primitives.LaunchName.Type
    object MaxExperiments extends Subtype[Int]
    type MaxExperiments = zio.aws.evidently.model.primitives.MaxExperiments.Type
    object MaxFeatures extends Subtype[Int]
    type MaxFeatures = zio.aws.evidently.model.primitives.MaxFeatures.Type
    object MaxLaunches extends Subtype[Int]
    type MaxLaunches = zio.aws.evidently.model.primitives.MaxLaunches.Type
    object MaxProjects extends Subtype[Int]
    type MaxProjects = zio.aws.evidently.model.primitives.MaxProjects.Type
    object MetricDefinitionConfigEventPatternString extends Subtype[String]
    type MetricDefinitionConfigEventPatternString =
      zio.aws.evidently.model.primitives.MetricDefinitionConfigEventPatternString.Type
    object MetricUnitLabel extends Subtype[String]
    type MetricUnitLabel =
      zio.aws.evidently.model.primitives.MetricUnitLabel.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.evidently.model.primitives.NextToken.Type
    object ProjectArn extends Subtype[String]
    type ProjectArn = zio.aws.evidently.model.primitives.ProjectArn.Type
    object ProjectName extends Subtype[String]
    type ProjectName = zio.aws.evidently.model.primitives.ProjectName.Type
    object ProjectRef extends Subtype[String]
    type ProjectRef = zio.aws.evidently.model.primitives.ProjectRef.Type
    object RandomizationSalt extends Subtype[String]
    type RandomizationSalt =
      zio.aws.evidently.model.primitives.RandomizationSalt.Type
    object ResultsPeriod extends Subtype[Long]
    type ResultsPeriod = zio.aws.evidently.model.primitives.ResultsPeriod.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.evidently.model.primitives.RuleName.Type
    object RuleType extends Subtype[String]
    type RuleType = zio.aws.evidently.model.primitives.RuleType.Type
    object S3BucketSafeName extends Subtype[String]
    type S3BucketSafeName =
      zio.aws.evidently.model.primitives.S3BucketSafeName.Type
    object S3PrefixSafeName extends Subtype[String]
    type S3PrefixSafeName =
      zio.aws.evidently.model.primitives.S3PrefixSafeName.Type
    object SplitWeight extends Subtype[Long]
    type SplitWeight = zio.aws.evidently.model.primitives.SplitWeight.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.evidently.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.evidently.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.evidently.model.primitives.Timestamp.Type
    object TreatmentName extends Subtype[String]
    type TreatmentName = zio.aws.evidently.model.primitives.TreatmentName.Type
    object Uuid extends Subtype[String]
    type Uuid = zio.aws.evidently.model.primitives.Uuid.Type
    object VariableValueLongValueLong extends Subtype[Long]
    type VariableValueLongValueLong =
      zio.aws.evidently.model.primitives.VariableValueLongValueLong.Type
    object VariableValueStringValueString extends Subtype[String]
    type VariableValueStringValueString =
      zio.aws.evidently.model.primitives.VariableValueStringValueString.Type
    object VariationName extends Subtype[String]
    type VariationName = zio.aws.evidently.model.primitives.VariationName.Type
  }
  type DoubleValueList = List[Double]
  type EntityOverrideMap = Map[EntityId, VariationName]
  type EvaluationRequestsList = List[zio.aws.evidently.model.EvaluationRequest]
  type EvaluationResultsList = List[zio.aws.evidently.model.EvaluationResult]
  type EvaluationRulesList = List[zio.aws.evidently.model.EvaluationRule]
  type EventList = List[zio.aws.evidently.model.Event]
  type ExperimentList = List[zio.aws.evidently.model.Experiment]
  type ExperimentReportList = List[zio.aws.evidently.model.ExperimentReport]
  type ExperimentReportNameList =
    List[zio.aws.evidently.model.ExperimentReportName]
  type ExperimentResultRequestTypeList =
    List[zio.aws.evidently.model.ExperimentResultRequestType]
  type ExperimentResultsDataList =
    List[zio.aws.evidently.model.ExperimentResultsData]
  type FeatureSummariesList = List[zio.aws.evidently.model.FeatureSummary]
  type FeatureToVariationMap = Map[FeatureName, VariationName]
  type GroupToWeightMap = Map[GroupName, SplitWeight]
  type LaunchGroupConfigList = List[zio.aws.evidently.model.LaunchGroupConfig]
  type LaunchGroupList = List[zio.aws.evidently.model.LaunchGroup]
  type LaunchesList = List[zio.aws.evidently.model.Launch]
  type MetricGoalConfigList = List[zio.aws.evidently.model.MetricGoalConfig]
  type MetricGoalsList = List[zio.aws.evidently.model.MetricGoal]
  type MetricMonitorConfigList =
    List[zio.aws.evidently.model.MetricMonitorConfig]
  type MetricMonitorList = List[zio.aws.evidently.model.MetricMonitor]
  type MetricNameList = List[CwDimensionSafeName]
  type ProjectSummariesList = List[zio.aws.evidently.model.ProjectSummary]
  type PutProjectEventsResultEntryList =
    List[zio.aws.evidently.model.PutProjectEventsResultEntry]
  type ScheduledSplitConfigList =
    List[zio.aws.evidently.model.ScheduledSplitConfig]
  type ScheduledStepList = List[zio.aws.evidently.model.ScheduledSplit]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TimestampList = List[Timestamp]
  type TreatmentConfigList = List[zio.aws.evidently.model.TreatmentConfig]
  type TreatmentList = List[zio.aws.evidently.model.Treatment]
  type TreatmentNameList = List[TreatmentName]
  type TreatmentToWeightMap = Map[TreatmentName, SplitWeight]
  type VariationConfigsList = List[zio.aws.evidently.model.VariationConfig]
  type VariationNameList = List[VariationName]
  type VariationsList = List[zio.aws.evidently.model.Variation]
}
