package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{TagKey, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: Arn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UntagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UntagResourceRequest.ReadOnly =
    zio.aws.evidently.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UntagResourceRequest =
      zio.aws.evidently.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: Arn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UntagResourceRequest
  ) extends zio.aws.evidently.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.evidently.model.primitives.Arn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.evidently.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UntagResourceRequest
  ): zio.aws.evidently.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
