package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{Description, ProjectRef, LaunchName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopLaunchRequest(
    desiredState: Option[zio.aws.evidently.model.LaunchStopDesiredState] = None,
    launch: LaunchName,
    project: ProjectRef,
    reason: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StopLaunchRequest = {
    import StopLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StopLaunchRequest
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .launch(LaunchName.unwrap(launch): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        reason.map(value => Description.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StopLaunchRequest.ReadOnly =
    zio.aws.evidently.model.StopLaunchRequest.wrap(buildAwsValue())
}
object StopLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StopLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StopLaunchRequest =
      zio.aws.evidently.model.StopLaunchRequest(
        desiredState.map(value => value),
        launch,
        project,
        reason.map(value => value)
      )
    def desiredState: Option[zio.aws.evidently.model.LaunchStopDesiredState]
    def launch: LaunchName
    def project: ProjectRef
    def reason: Option[Description]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.evidently.model.LaunchStopDesiredState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getLaunch: ZIO[Any, Nothing, LaunchName] = ZIO.succeed(launch)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getReason: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StopLaunchRequest
  ) extends zio.aws.evidently.model.StopLaunchRequest.ReadOnly {
    override val desiredState
        : Option[zio.aws.evidently.model.LaunchStopDesiredState] = scala
      .Option(impl.desiredState())
      .map(value => zio.aws.evidently.model.LaunchStopDesiredState.wrap(value))
    override val launch: LaunchName =
      zio.aws.evidently.model.primitives.LaunchName(impl.launch())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val reason: Option[Description] = scala
      .Option(impl.reason())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StopLaunchRequest
  ): zio.aws.evidently.model.StopLaunchRequest.ReadOnly = new Wrapper(impl)
}
