package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutProjectEventsResponse(
    eventResults: Option[
      Iterable[zio.aws.evidently.model.PutProjectEventsResultEntry]
    ] = None,
    failedEventCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse = {
    import PutProjectEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
      .builder()
      .optionallyWith(
        eventResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventResults)
      .optionallyWith(failedEventCount.map(value => value: java.lang.Integer))(
        _.failedEventCount
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly =
    zio.aws.evidently.model.PutProjectEventsResponse.wrap(buildAwsValue())
}
object PutProjectEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.PutProjectEventsResponse =
      zio.aws.evidently.model.PutProjectEventsResponse(
        eventResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedEventCount.map(value => value)
      )
    def eventResults: Option[
      List[zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly]
    ]
    def failedEventCount: Option[Integer]
    def getEventResults: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("eventResults", eventResults)
    def getFailedEventCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedEventCount", failedEventCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
  ) extends zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly {
    override val eventResults: Option[
      List[zio.aws.evidently.model.PutProjectEventsResultEntry.ReadOnly]
    ] = scala
      .Option(impl.eventResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.PutProjectEventsResultEntry.wrap(item)
        }.toList
      )
    override val failedEventCount: Option[Integer] =
      scala.Option(impl.failedEventCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse
  ): zio.aws.evidently.model.PutProjectEventsResponse.ReadOnly = new Wrapper(
    impl
  )
}
