package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricGoal(
    desiredChange: Option[zio.aws.evidently.model.ChangeDirectionEnum] = None,
    metricDefinition: zio.aws.evidently.model.MetricDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricGoal = {
    import MetricGoal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricGoal
      .builder()
      .optionallyWith(desiredChange.map(value => value.unwrap))(_.desiredChange)
      .metricDefinition(metricDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricGoal.ReadOnly =
    zio.aws.evidently.model.MetricGoal.wrap(buildAwsValue())
}
object MetricGoal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricGoal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricGoal =
      zio.aws.evidently.model.MetricGoal(
        desiredChange.map(value => value),
        metricDefinition.asEditable
      )
    def desiredChange: Option[zio.aws.evidently.model.ChangeDirectionEnum]
    def metricDefinition: zio.aws.evidently.model.MetricDefinition.ReadOnly
    def getDesiredChange
        : ZIO[Any, AwsError, zio.aws.evidently.model.ChangeDirectionEnum] =
      AwsError.unwrapOptionField("desiredChange", desiredChange)
    def getMetricDefinition
        : ZIO[Any, Nothing, zio.aws.evidently.model.MetricDefinition.ReadOnly] =
      ZIO.succeed(metricDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricGoal
  ) extends zio.aws.evidently.model.MetricGoal.ReadOnly {
    override val desiredChange
        : Option[zio.aws.evidently.model.ChangeDirectionEnum] = scala
      .Option(impl.desiredChange())
      .map(value => zio.aws.evidently.model.ChangeDirectionEnum.wrap(value))
    override val metricDefinition
        : zio.aws.evidently.model.MetricDefinition.ReadOnly =
      zio.aws.evidently.model.MetricDefinition.wrap(impl.metricDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricGoal
  ): zio.aws.evidently.model.MetricGoal.ReadOnly = new Wrapper(impl)
}
