package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    nextToken: Option[NextToken] = None,
    projects: Option[Iterable[zio.aws.evidently.model.ProjectSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListProjectsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projects)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListProjectsResponse.ReadOnly =
    zio.aws.evidently.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListProjectsResponse =
      zio.aws.evidently.model.ListProjectsResponse(
        nextToken.map(value => value),
        projects.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def projects: Option[List[zio.aws.evidently.model.ProjectSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjects: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ProjectSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("projects", projects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListProjectsResponse
  ) extends zio.aws.evidently.model.ListProjectsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val projects
        : Option[List[zio.aws.evidently.model.ProjectSummary.ReadOnly]] = scala
      .Option(impl.projects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.ProjectSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListProjectsResponse
  ): zio.aws.evidently.model.ListProjectsResponse.ReadOnly = new Wrapper(impl)
}
