package zio.aws.evidently.model
import java.lang.Integer
import zio.aws.evidently.model.primitives.{ProjectRef, NextToken, MaxLaunches}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLaunchesRequest(
    maxResults: Option[MaxLaunches] = None,
    nextToken: Option[NextToken] = None,
    project: ProjectRef,
    status: Option[zio.aws.evidently.model.LaunchStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListLaunchesRequest = {
    import ListLaunchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxLaunches.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListLaunchesRequest.ReadOnly =
    zio.aws.evidently.model.ListLaunchesRequest.wrap(buildAwsValue())
}
object ListLaunchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListLaunchesRequest =
      zio.aws.evidently.model.ListLaunchesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        project,
        status.map(value => value)
      )
    def maxResults: Option[MaxLaunches]
    def nextToken: Option[NextToken]
    def project: ProjectRef
    def status: Option[zio.aws.evidently.model.LaunchStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxLaunches] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getStatus: ZIO[Any, AwsError, zio.aws.evidently.model.LaunchStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
  ) extends zio.aws.evidently.model.ListLaunchesRequest.ReadOnly {
    override val maxResults: Option[MaxLaunches] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxLaunches(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val status: Option[zio.aws.evidently.model.LaunchStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.evidently.model.LaunchStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListLaunchesRequest
  ): zio.aws.evidently.model.ListLaunchesRequest.ReadOnly = new Wrapper(impl)
}
