package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExperimentsResponse(
    experiments: Option[Iterable[zio.aws.evidently.model.Experiment]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListExperimentsResponse = {
    import ListExperimentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListExperimentsResponse
      .builder()
      .optionallyWith(
        experiments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.experiments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListExperimentsResponse.ReadOnly =
    zio.aws.evidently.model.ListExperimentsResponse.wrap(buildAwsValue())
}
object ListExperimentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListExperimentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListExperimentsResponse =
      zio.aws.evidently.model.ListExperimentsResponse(
        experiments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def experiments: Option[List[zio.aws.evidently.model.Experiment.ReadOnly]]
    def nextToken: Option[NextToken]
    def getExperiments: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.Experiment.ReadOnly
    ]] = AwsError.unwrapOptionField("experiments", experiments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListExperimentsResponse
  ) extends zio.aws.evidently.model.ListExperimentsResponse.ReadOnly {
    override val experiments
        : Option[List[zio.aws.evidently.model.Experiment.ReadOnly]] = scala
      .Option(impl.experiments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.Experiment.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListExperimentsResponse
  ): zio.aws.evidently.model.ListExperimentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
