package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProjectResponse(project: zio.aws.evidently.model.Project) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetProjectResponse = {
    import GetProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetProjectResponse
      .builder()
      .project(project.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetProjectResponse.ReadOnly =
    zio.aws.evidently.model.GetProjectResponse.wrap(buildAwsValue())
}
object GetProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetProjectResponse =
      zio.aws.evidently.model.GetProjectResponse(project.asEditable)
    def project: zio.aws.evidently.model.Project.ReadOnly
    def getProject
        : ZIO[Any, Nothing, zio.aws.evidently.model.Project.ReadOnly] =
      ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetProjectResponse
  ) extends zio.aws.evidently.model.GetProjectResponse.ReadOnly {
    override val project: zio.aws.evidently.model.Project.ReadOnly =
      zio.aws.evidently.model.Project.wrap(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetProjectResponse
  ): zio.aws.evidently.model.GetProjectResponse.ReadOnly = new Wrapper(impl)
}
