package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.ProjectRef
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProjectRequest(project: ProjectRef) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetProjectRequest = {
    import GetProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetProjectRequest
      .builder()
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetProjectRequest.ReadOnly =
    zio.aws.evidently.model.GetProjectRequest.wrap(buildAwsValue())
}
object GetProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetProjectRequest =
      zio.aws.evidently.model.GetProjectRequest(project)
    def project: ProjectRef
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetProjectRequest
  ) extends zio.aws.evidently.model.GetProjectRequest.ReadOnly {
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetProjectRequest
  ): zio.aws.evidently.model.GetProjectRequest.ReadOnly = new Wrapper(impl)
}
