package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetExperimentResultsResponse(
    reports: Option[Iterable[zio.aws.evidently.model.ExperimentReport]] = None,
    resultsData: Option[
      Iterable[zio.aws.evidently.model.ExperimentResultsData]
    ] = None,
    timestamps: Option[Iterable[Timestamp]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse = {
    import GetExperimentResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
      .builder()
      .optionallyWith(
        reports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reports)
      .optionallyWith(
        resultsData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultsData)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly =
    zio.aws.evidently.model.GetExperimentResultsResponse.wrap(buildAwsValue())
}
object GetExperimentResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetExperimentResultsResponse =
      zio.aws.evidently.model.GetExperimentResultsResponse(
        reports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultsData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timestamps.map(value => value)
      )
    def reports: Option[List[zio.aws.evidently.model.ExperimentReport.ReadOnly]]
    def resultsData
        : Option[List[zio.aws.evidently.model.ExperimentResultsData.ReadOnly]]
    def timestamps: Option[List[Timestamp]]
    def getReports: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ExperimentReport.ReadOnly
    ]] = AwsError.unwrapOptionField("reports", reports)
    def getResultsData: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ExperimentResultsData.ReadOnly
    ]] = AwsError.unwrapOptionField("resultsData", resultsData)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
  ) extends zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly {
    override val reports
        : Option[List[zio.aws.evidently.model.ExperimentReport.ReadOnly]] =
      scala
        .Option(impl.reports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.ExperimentReport.wrap(item)
          }.toList
        )
    override val resultsData
        : Option[List[zio.aws.evidently.model.ExperimentResultsData.ReadOnly]] =
      scala
        .Option(impl.resultsData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.ExperimentResultsData.wrap(item)
          }.toList
        )
    override val timestamps: Option[List[Timestamp]] = scala
      .Option(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.primitives.Timestamp(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse
  ): zio.aws.evidently.model.GetExperimentResultsResponse.ReadOnly =
    new Wrapper(impl)
}
