package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  Timestamp,
  ProjectRef,
  TreatmentName,
  ResultsPeriod,
  ExperimentName,
  CwDimensionSafeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetExperimentResultsRequest(
    baseStat: Option[zio.aws.evidently.model.ExperimentBaseStat] = None,
    endTime: Option[Timestamp] = None,
    experiment: ExperimentName,
    metricNames: Iterable[CwDimensionSafeName],
    period: Option[ResultsPeriod] = None,
    project: ProjectRef,
    reportNames: Option[
      Iterable[zio.aws.evidently.model.ExperimentReportName]
    ] = None,
    resultStats: Option[
      Iterable[zio.aws.evidently.model.ExperimentResultRequestType]
    ] = None,
    startTime: Option[Timestamp] = None,
    treatmentNames: Iterable[TreatmentName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest = {
    import GetExperimentResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest
      .builder()
      .optionallyWith(baseStat.map(value => value.unwrap))(_.baseStat)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .experiment(ExperimentName.unwrap(experiment): java.lang.String)
      .metricNames(metricNames.map { item =>
        CwDimensionSafeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        period.map(value => ResultsPeriod.unwrap(value): java.lang.Long)
      )(_.period)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        reportNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reportNamesWithStrings)
      .optionallyWith(
        resultStats.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resultStatsWithStrings)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .treatmentNames(treatmentNames.map { item =>
        TreatmentName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetExperimentResultsRequest.ReadOnly =
    zio.aws.evidently.model.GetExperimentResultsRequest.wrap(buildAwsValue())
}
object GetExperimentResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetExperimentResultsRequest =
      zio.aws.evidently.model.GetExperimentResultsRequest(
        baseStat.map(value => value),
        endTime.map(value => value),
        experiment,
        metricNames,
        period.map(value => value),
        project,
        reportNames.map(value => value),
        resultStats.map(value => value),
        startTime.map(value => value),
        treatmentNames
      )
    def baseStat: Option[zio.aws.evidently.model.ExperimentBaseStat]
    def endTime: Option[Timestamp]
    def experiment: ExperimentName
    def metricNames: List[CwDimensionSafeName]
    def period: Option[ResultsPeriod]
    def project: ProjectRef
    def reportNames: Option[List[zio.aws.evidently.model.ExperimentReportName]]
    def resultStats
        : Option[List[zio.aws.evidently.model.ExperimentResultRequestType]]
    def startTime: Option[Timestamp]
    def treatmentNames: List[TreatmentName]
    def getBaseStat
        : ZIO[Any, AwsError, zio.aws.evidently.model.ExperimentBaseStat] =
      AwsError.unwrapOptionField("baseStat", baseStat)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getExperiment: ZIO[Any, Nothing, ExperimentName] =
      ZIO.succeed(experiment)
    def getMetricNames: ZIO[Any, Nothing, List[CwDimensionSafeName]] =
      ZIO.succeed(metricNames)
    def getPeriod: ZIO[Any, AwsError, ResultsPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getReportNames: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ExperimentReportName
    ]] = AwsError.unwrapOptionField("reportNames", reportNames)
    def getResultStats: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.ExperimentResultRequestType
    ]] = AwsError.unwrapOptionField("resultStats", resultStats)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTreatmentNames: ZIO[Any, Nothing, List[TreatmentName]] =
      ZIO.succeed(treatmentNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest
  ) extends zio.aws.evidently.model.GetExperimentResultsRequest.ReadOnly {
    override val baseStat: Option[zio.aws.evidently.model.ExperimentBaseStat] =
      scala
        .Option(impl.baseStat())
        .map(value => zio.aws.evidently.model.ExperimentBaseStat.wrap(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
    override val experiment: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.experiment())
    override val metricNames: List[CwDimensionSafeName] = impl
      .metricNames()
      .asScala
      .map { item =>
        zio.aws.evidently.model.primitives.CwDimensionSafeName(item)
      }
      .toList
    override val period: Option[ResultsPeriod] = scala
      .Option(impl.period())
      .map(value => zio.aws.evidently.model.primitives.ResultsPeriod(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val reportNames
        : Option[List[zio.aws.evidently.model.ExperimentReportName]] = scala
      .Option(impl.reportNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.ExperimentReportName.wrap(item)
        }.toList
      )
    override val resultStats
        : Option[List[zio.aws.evidently.model.ExperimentResultRequestType]] =
      scala
        .Option(impl.resultStats())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.ExperimentResultRequestType.wrap(item)
          }.toList
        )
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
    override val treatmentNames: List[TreatmentName] = impl
      .treatmentNames()
      .asScala
      .map { item =>
        zio.aws.evidently.model.primitives.TreatmentName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest
  ): zio.aws.evidently.model.GetExperimentResultsRequest.ReadOnly = new Wrapper(
    impl
  )
}
