package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{TreatmentName, CwDimensionSafeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExperimentResultsData(
    metricName: Option[CwDimensionSafeName] = None,
    resultStat: Option[zio.aws.evidently.model.ExperimentResultResponseType] =
      None,
    treatmentName: Option[TreatmentName] = None,
    values: Option[Iterable[Double]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ExperimentResultsData = {
    import ExperimentResultsData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ExperimentResultsData
      .builder()
      .optionallyWith(
        metricName.map(value =>
          CwDimensionSafeName.unwrap(value): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(resultStat.map(value => value.unwrap))(_.resultStat)
      .optionallyWith(
        treatmentName.map(value =>
          TreatmentName.unwrap(value): java.lang.String
        )
      )(_.treatmentName)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ExperimentResultsData.ReadOnly =
    zio.aws.evidently.model.ExperimentResultsData.wrap(buildAwsValue())
}
object ExperimentResultsData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ExperimentResultsData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ExperimentResultsData =
      zio.aws.evidently.model.ExperimentResultsData(
        metricName.map(value => value),
        resultStat.map(value => value),
        treatmentName.map(value => value),
        values.map(value => value)
      )
    def metricName: Option[CwDimensionSafeName]
    def resultStat: Option[zio.aws.evidently.model.ExperimentResultResponseType]
    def treatmentName: Option[TreatmentName]
    def values: Option[List[Double]]
    def getMetricName: ZIO[Any, AwsError, CwDimensionSafeName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getResultStat: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ExperimentResultResponseType
    ] = AwsError.unwrapOptionField("resultStat", resultStat)
    def getTreatmentName: ZIO[Any, AwsError, TreatmentName] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
    def getValues: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentResultsData
  ) extends zio.aws.evidently.model.ExperimentResultsData.ReadOnly {
    override val metricName: Option[CwDimensionSafeName] = scala
      .Option(impl.metricName())
      .map(value =>
        zio.aws.evidently.model.primitives.CwDimensionSafeName(value)
      )
    override val resultStat
        : Option[zio.aws.evidently.model.ExperimentResultResponseType] = scala
      .Option(impl.resultStat())
      .map(value =>
        zio.aws.evidently.model.ExperimentResultResponseType.wrap(value)
      )
    override val treatmentName: Option[TreatmentName] = scala
      .Option(impl.treatmentName())
      .map(value => zio.aws.evidently.model.primitives.TreatmentName(value))
    override val values: Option[List[Double]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentResultsData
  ): zio.aws.evidently.model.ExperimentResultsData.ReadOnly = new Wrapper(impl)
}
