package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  TreatmentName,
  CwDimensionSafeName,
  JsonValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExperimentReport(
    content: Option[JsonValue] = None,
    metricName: Option[CwDimensionSafeName] = None,
    reportName: Option[zio.aws.evidently.model.ExperimentReportName] = None,
    treatmentName: Option[TreatmentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ExperimentReport = {
    import ExperimentReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ExperimentReport
      .builder()
      .optionallyWith(
        content.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metricName.map(value =>
          CwDimensionSafeName.unwrap(value): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(reportName.map(value => value.unwrap))(_.reportName)
      .optionallyWith(
        treatmentName.map(value =>
          TreatmentName.unwrap(value): java.lang.String
        )
      )(_.treatmentName)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ExperimentReport.ReadOnly =
    zio.aws.evidently.model.ExperimentReport.wrap(buildAwsValue())
}
object ExperimentReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ExperimentReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ExperimentReport =
      zio.aws.evidently.model.ExperimentReport(
        content.map(value => value),
        metricName.map(value => value),
        reportName.map(value => value),
        treatmentName.map(value => value)
      )
    def content: Option[JsonValue]
    def metricName: Option[CwDimensionSafeName]
    def reportName: Option[zio.aws.evidently.model.ExperimentReportName]
    def treatmentName: Option[TreatmentName]
    def getContent: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("content", content)
    def getMetricName: ZIO[Any, AwsError, CwDimensionSafeName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getReportName
        : ZIO[Any, AwsError, zio.aws.evidently.model.ExperimentReportName] =
      AwsError.unwrapOptionField("reportName", reportName)
    def getTreatmentName: ZIO[Any, AwsError, TreatmentName] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentReport
  ) extends zio.aws.evidently.model.ExperimentReport.ReadOnly {
    override val content: Option[JsonValue] = scala
      .Option(impl.content())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val metricName: Option[CwDimensionSafeName] = scala
      .Option(impl.metricName())
      .map(value =>
        zio.aws.evidently.model.primitives.CwDimensionSafeName(value)
      )
    override val reportName
        : Option[zio.aws.evidently.model.ExperimentReportName] = scala
      .Option(impl.reportName())
      .map(value => zio.aws.evidently.model.ExperimentReportName.wrap(value))
    override val treatmentName: Option[TreatmentName] = scala
      .Option(impl.treatmentName())
      .map(value => zio.aws.evidently.model.primitives.TreatmentName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentReport
  ): zio.aws.evidently.model.ExperimentReport.ReadOnly = new Wrapper(impl)
}
