package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{FeatureName, JsonValue, EntityId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EvaluationRequest(
    entityId: EntityId,
    evaluationContext: Option[JsonValue] = None,
    feature: FeatureName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.EvaluationRequest = {
    import EvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.EvaluationRequest
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .optionallyWith(
        evaluationContext.map(value =>
          JsonValue.unwrap(value): java.lang.String
        )
      )(_.evaluationContext)
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.EvaluationRequest.ReadOnly =
    zio.aws.evidently.model.EvaluationRequest.wrap(buildAwsValue())
}
object EvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.EvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.EvaluationRequest =
      zio.aws.evidently.model.EvaluationRequest(
        entityId,
        evaluationContext.map(value => value),
        feature
      )
    def entityId: EntityId
    def evaluationContext: Option[JsonValue]
    def feature: FeatureName
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEvaluationContext: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("evaluationContext", evaluationContext)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.EvaluationRequest
  ) extends zio.aws.evidently.model.EvaluationRequest.ReadOnly {
    override val entityId: EntityId =
      zio.aws.evidently.model.primitives.EntityId(impl.entityId())
    override val evaluationContext: Option[JsonValue] = scala
      .Option(impl.evaluationContext())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.EvaluationRequest
  ): zio.aws.evidently.model.EvaluationRequest.ReadOnly = new Wrapper(impl)
}
