package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFeatureResponse(
    feature: Option[zio.aws.evidently.model.Feature] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateFeatureResponse = {
    import CreateFeatureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateFeatureResponse
      .builder()
      .optionallyWith(feature.map(value => value.buildAwsValue()))(_.feature)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateFeatureResponse.ReadOnly =
    zio.aws.evidently.model.CreateFeatureResponse.wrap(buildAwsValue())
}
object CreateFeatureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateFeatureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateFeatureResponse =
      zio.aws.evidently.model
        .CreateFeatureResponse(feature.map(value => value.asEditable))
    def feature: Option[zio.aws.evidently.model.Feature.ReadOnly]
    def getFeature
        : ZIO[Any, AwsError, zio.aws.evidently.model.Feature.ReadOnly] =
      AwsError.unwrapOptionField("feature", feature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateFeatureResponse
  ) extends zio.aws.evidently.model.CreateFeatureResponse.ReadOnly {
    override val feature: Option[zio.aws.evidently.model.Feature.ReadOnly] =
      scala
        .Option(impl.feature())
        .map(value => zio.aws.evidently.model.Feature.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateFeatureResponse
  ): zio.aws.evidently.model.CreateFeatureResponse.ReadOnly = new Wrapper(impl)
}
