package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.ProjectRef
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateProjectDataDeliveryRequest(
    cloudWatchLogs: Option[
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig
    ] = None,
    project: ProjectRef,
    s3Destination: Option[zio.aws.evidently.model.S3DestinationConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest = {
    import UpdateProjectDataDeliveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.UpdateProjectDataDeliveryRequest.ReadOnly =
    zio.aws.evidently.model.UpdateProjectDataDeliveryRequest
      .wrap(buildAwsValue())
}
object UpdateProjectDataDeliveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateProjectDataDeliveryRequest =
      zio.aws.evidently.model.UpdateProjectDataDeliveryRequest(
        cloudWatchLogs.map(value => value.asEditable),
        project,
        s3Destination.map(value => value.asEditable)
      )
    def cloudWatchLogs: Option[
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly
    ]
    def project: ProjectRef
    def s3Destination
        : Option[zio.aws.evidently.model.S3DestinationConfig.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.S3DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest
  ) extends zio.aws.evidently.model.UpdateProjectDataDeliveryRequest.ReadOnly {
    override val cloudWatchLogs: Option[
      zio.aws.evidently.model.CloudWatchLogsDestinationConfig.ReadOnly
    ] = scala
      .Option(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.evidently.model.CloudWatchLogsDestinationConfig.wrap(value)
      )
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val s3Destination
        : Option[zio.aws.evidently.model.S3DestinationConfig.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.evidently.model.S3DestinationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest
  ): zio.aws.evidently.model.UpdateProjectDataDeliveryRequest.ReadOnly =
    new Wrapper(impl)
}
