package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariationName,
  ProjectRef,
  Description,
  EntityId,
  FeatureName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFeatureRequest(
    addOrUpdateVariations: Option[
      Iterable[zio.aws.evidently.model.VariationConfig]
    ] = None,
    defaultVariation: Option[VariationName] = None,
    description: Option[Description] = None,
    entityOverrides: Option[Map[EntityId, VariationName]] = None,
    evaluationStrategy: Option[
      zio.aws.evidently.model.FeatureEvaluationStrategy
    ] = None,
    feature: FeatureName,
    project: ProjectRef,
    removeVariations: Option[Iterable[VariationName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest = {
    import UpdateFeatureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
      .builder()
      .optionallyWith(
        addOrUpdateVariations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOrUpdateVariations)
      .optionallyWith(
        defaultVariation.map(value =>
          VariationName.unwrap(value): java.lang.String
        )
      )(_.defaultVariation)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        entityOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (EntityId.unwrap(key): java.lang.String) -> (VariationName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.entityOverrides)
      .optionallyWith(evaluationStrategy.map(value => value.unwrap))(
        _.evaluationStrategy
      )
      .feature(FeatureName.unwrap(feature): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        removeVariations.map(value =>
          value.map { item =>
            VariationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeVariations)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.UpdateFeatureRequest.ReadOnly =
    zio.aws.evidently.model.UpdateFeatureRequest.wrap(buildAwsValue())
}
object UpdateFeatureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.UpdateFeatureRequest =
      zio.aws.evidently.model.UpdateFeatureRequest(
        addOrUpdateVariations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultVariation.map(value => value),
        description.map(value => value),
        entityOverrides.map(value => value),
        evaluationStrategy.map(value => value),
        feature,
        project,
        removeVariations.map(value => value)
      )
    def addOrUpdateVariations
        : Option[List[zio.aws.evidently.model.VariationConfig.ReadOnly]]
    def defaultVariation: Option[VariationName]
    def description: Option[Description]
    def entityOverrides: Option[Map[EntityId, VariationName]]
    def evaluationStrategy
        : Option[zio.aws.evidently.model.FeatureEvaluationStrategy]
    def feature: FeatureName
    def project: ProjectRef
    def removeVariations: Option[List[VariationName]]
    def getAddOrUpdateVariations: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.VariationConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("addOrUpdateVariations", addOrUpdateVariations)
    def getDefaultVariation: ZIO[Any, AwsError, VariationName] =
      AwsError.unwrapOptionField("defaultVariation", defaultVariation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityOverrides: ZIO[Any, AwsError, Map[EntityId, VariationName]] =
      AwsError.unwrapOptionField("entityOverrides", entityOverrides)
    def getEvaluationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.FeatureEvaluationStrategy
    ] = AwsError.unwrapOptionField("evaluationStrategy", evaluationStrategy)
    def getFeature: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(feature)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRemoveVariations: ZIO[Any, AwsError, List[VariationName]] =
      AwsError.unwrapOptionField("removeVariations", removeVariations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
  ) extends zio.aws.evidently.model.UpdateFeatureRequest.ReadOnly {
    override val addOrUpdateVariations
        : Option[List[zio.aws.evidently.model.VariationConfig.ReadOnly]] = scala
      .Option(impl.addOrUpdateVariations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.VariationConfig.wrap(item)
        }.toList
      )
    override val defaultVariation: Option[VariationName] = scala
      .Option(impl.defaultVariation())
      .map(value => zio.aws.evidently.model.primitives.VariationName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val entityOverrides: Option[Map[EntityId, VariationName]] = scala
      .Option(impl.entityOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives.EntityId(
              key
            ) -> zio.aws.evidently.model.primitives.VariationName(value)
          })
          .toMap
      )
    override val evaluationStrategy
        : Option[zio.aws.evidently.model.FeatureEvaluationStrategy] = scala
      .Option(impl.evaluationStrategy())
      .map(value =>
        zio.aws.evidently.model.FeatureEvaluationStrategy.wrap(value)
      )
    override val feature: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.feature())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val removeVariations: Option[List[VariationName]] = scala
      .Option(impl.removeVariations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.primitives.VariationName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest
  ): zio.aws.evidently.model.UpdateFeatureRequest.ReadOnly = new Wrapper(impl)
}
