package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.ProjectRef
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutProjectEventsRequest(
    events: Iterable[zio.aws.evidently.model.Event],
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest = {
    import PutProjectEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.PutProjectEventsRequest.ReadOnly =
    zio.aws.evidently.model.PutProjectEventsRequest.wrap(buildAwsValue())
}
object PutProjectEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.PutProjectEventsRequest =
      zio.aws.evidently.model.PutProjectEventsRequest(
        events.map { item =>
          item.asEditable
        },
        project
      )
    def events: List[zio.aws.evidently.model.Event.ReadOnly]
    def project: ProjectRef
    def getEvents
        : ZIO[Any, Nothing, List[zio.aws.evidently.model.Event.ReadOnly]] =
      ZIO.succeed(events)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest
  ) extends zio.aws.evidently.model.PutProjectEventsRequest.ReadOnly {
    override val events: List[zio.aws.evidently.model.Event.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.evidently.model.Event.wrap(item)
      }
      .toList
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest
  ): zio.aws.evidently.model.PutProjectEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
