package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProjectDataDelivery(
    cloudWatchLogs: Option[zio.aws.evidently.model.CloudWatchLogsDestination] =
      None,
    s3Destination: Option[zio.aws.evidently.model.S3Destination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ProjectDataDelivery = {
    import ProjectDataDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ProjectDataDelivery.ReadOnly =
    zio.aws.evidently.model.ProjectDataDelivery.wrap(buildAwsValue())
}
object ProjectDataDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ProjectDataDelivery =
      zio.aws.evidently.model.ProjectDataDelivery(
        cloudWatchLogs.map(value => value.asEditable),
        s3Destination.map(value => value.asEditable)
      )
    def cloudWatchLogs
        : Option[zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly]
    def s3Destination: Option[zio.aws.evidently.model.S3Destination.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Destination
        : ZIO[Any, AwsError, zio.aws.evidently.model.S3Destination.ReadOnly] =
      AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
  ) extends zio.aws.evidently.model.ProjectDataDelivery.ReadOnly {
    override val cloudWatchLogs
        : Option[zio.aws.evidently.model.CloudWatchLogsDestination.ReadOnly] =
      scala
        .Option(impl.cloudWatchLogs())
        .map(value =>
          zio.aws.evidently.model.CloudWatchLogsDestination.wrap(value)
        )
    override val s3Destination
        : Option[zio.aws.evidently.model.S3Destination.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.evidently.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ProjectDataDelivery
  ): zio.aws.evidently.model.ProjectDataDelivery.ReadOnly = new Wrapper(impl)
}
