package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  MetricUnitLabel,
  CwDimensionSafeName,
  MetricDefinitionConfigEventPatternString,
  JsonPath
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricDefinitionConfig(
    entityIdKey: Option[JsonPath] = None,
    eventPattern: Option[MetricDefinitionConfigEventPatternString] = None,
    name: Option[CwDimensionSafeName] = None,
    unitLabel: Option[MetricUnitLabel] = None,
    valueKey: Option[JsonPath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig = {
    import MetricDefinitionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
      .builder()
      .optionallyWith(
        entityIdKey.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.entityIdKey)
      .optionallyWith(
        eventPattern.map(value =>
          MetricDefinitionConfigEventPatternString.unwrap(
            value
          ): java.lang.String
        )
      )(_.eventPattern)
      .optionallyWith(
        name.map(value => CwDimensionSafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        unitLabel.map(value => MetricUnitLabel.unwrap(value): java.lang.String)
      )(_.unitLabel)
      .optionallyWith(
        valueKey.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.valueKey)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly =
    zio.aws.evidently.model.MetricDefinitionConfig.wrap(buildAwsValue())
}
object MetricDefinitionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricDefinitionConfig =
      zio.aws.evidently.model.MetricDefinitionConfig(
        entityIdKey.map(value => value),
        eventPattern.map(value => value),
        name.map(value => value),
        unitLabel.map(value => value),
        valueKey.map(value => value)
      )
    def entityIdKey: Option[JsonPath]
    def eventPattern: Option[MetricDefinitionConfigEventPatternString]
    def name: Option[CwDimensionSafeName]
    def unitLabel: Option[MetricUnitLabel]
    def valueKey: Option[JsonPath]
    def getEntityIdKey: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("entityIdKey", entityIdKey)
    def getEventPattern
        : ZIO[Any, AwsError, MetricDefinitionConfigEventPatternString] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getName: ZIO[Any, AwsError, CwDimensionSafeName] =
      AwsError.unwrapOptionField("name", name)
    def getUnitLabel: ZIO[Any, AwsError, MetricUnitLabel] =
      AwsError.unwrapOptionField("unitLabel", unitLabel)
    def getValueKey: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("valueKey", valueKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
  ) extends zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly {
    override val entityIdKey: Option[JsonPath] = scala
      .Option(impl.entityIdKey())
      .map(value => zio.aws.evidently.model.primitives.JsonPath(value))
    override val eventPattern
        : Option[MetricDefinitionConfigEventPatternString] = scala
      .Option(impl.eventPattern())
      .map(value =>
        zio.aws.evidently.model.primitives
          .MetricDefinitionConfigEventPatternString(value)
      )
    override val name: Option[CwDimensionSafeName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.evidently.model.primitives.CwDimensionSafeName(value)
      )
    override val unitLabel: Option[MetricUnitLabel] = scala
      .Option(impl.unitLabel())
      .map(value => zio.aws.evidently.model.primitives.MetricUnitLabel(value))
    override val valueKey: Option[JsonPath] = scala
      .Option(impl.valueKey())
      .map(value => zio.aws.evidently.model.primitives.JsonPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinitionConfig
  ): zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly = new Wrapper(impl)
}
