package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  MetricUnitLabel,
  CwDimensionSafeName,
  JsonValue,
  JsonPath
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricDefinition(
    entityIdKey: Option[JsonPath] = None,
    eventPattern: Option[JsonValue] = None,
    name: Option[CwDimensionSafeName] = None,
    unitLabel: Option[MetricUnitLabel] = None,
    valueKey: Option[JsonPath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricDefinition = {
    import MetricDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricDefinition
      .builder()
      .optionallyWith(
        entityIdKey.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.entityIdKey)
      .optionallyWith(
        eventPattern.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(
        name.map(value => CwDimensionSafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        unitLabel.map(value => MetricUnitLabel.unwrap(value): java.lang.String)
      )(_.unitLabel)
      .optionallyWith(
        valueKey.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.valueKey)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricDefinition.ReadOnly =
    zio.aws.evidently.model.MetricDefinition.wrap(buildAwsValue())
}
object MetricDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricDefinition =
      zio.aws.evidently.model.MetricDefinition(
        entityIdKey.map(value => value),
        eventPattern.map(value => value),
        name.map(value => value),
        unitLabel.map(value => value),
        valueKey.map(value => value)
      )
    def entityIdKey: Option[JsonPath]
    def eventPattern: Option[JsonValue]
    def name: Option[CwDimensionSafeName]
    def unitLabel: Option[MetricUnitLabel]
    def valueKey: Option[JsonPath]
    def getEntityIdKey: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("entityIdKey", entityIdKey)
    def getEventPattern: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getName: ZIO[Any, AwsError, CwDimensionSafeName] =
      AwsError.unwrapOptionField("name", name)
    def getUnitLabel: ZIO[Any, AwsError, MetricUnitLabel] =
      AwsError.unwrapOptionField("unitLabel", unitLabel)
    def getValueKey: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("valueKey", valueKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinition
  ) extends zio.aws.evidently.model.MetricDefinition.ReadOnly {
    override val entityIdKey: Option[JsonPath] = scala
      .Option(impl.entityIdKey())
      .map(value => zio.aws.evidently.model.primitives.JsonPath(value))
    override val eventPattern: Option[JsonValue] = scala
      .Option(impl.eventPattern())
      .map(value => zio.aws.evidently.model.primitives.JsonValue(value))
    override val name: Option[CwDimensionSafeName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.evidently.model.primitives.CwDimensionSafeName(value)
      )
    override val unitLabel: Option[MetricUnitLabel] = scala
      .Option(impl.unitLabel())
      .map(value => zio.aws.evidently.model.primitives.MetricUnitLabel(value))
    override val valueKey: Option[JsonPath] = scala
      .Option(impl.valueKey())
      .map(value => zio.aws.evidently.model.primitives.JsonPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricDefinition
  ): zio.aws.evidently.model.MetricDefinition.ReadOnly = new Wrapper(impl)
}
