package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLaunchesResponse(
    launches: Option[Iterable[zio.aws.evidently.model.Launch]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListLaunchesResponse = {
    import ListLaunchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListLaunchesResponse
      .builder()
      .optionallyWith(
        launches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launches)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListLaunchesResponse.ReadOnly =
    zio.aws.evidently.model.ListLaunchesResponse.wrap(buildAwsValue())
}
object ListLaunchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListLaunchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListLaunchesResponse =
      zio.aws.evidently.model.ListLaunchesResponse(
        launches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def launches: Option[List[zio.aws.evidently.model.Launch.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLaunches
        : ZIO[Any, AwsError, List[zio.aws.evidently.model.Launch.ReadOnly]] =
      AwsError.unwrapOptionField("launches", launches)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListLaunchesResponse
  ) extends zio.aws.evidently.model.ListLaunchesResponse.ReadOnly {
    override val launches
        : Option[List[zio.aws.evidently.model.Launch.ReadOnly]] = scala
      .Option(impl.launches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.Launch.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListLaunchesResponse
  ): zio.aws.evidently.model.ListLaunchesResponse.ReadOnly = new Wrapper(impl)
}
